﻿using FamilyBudget.Data;
using FamilyBudget.Models;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Rendering;
using Microsoft.Data.SqlClient;
using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace FamilyBudget.Controllers
{
    public class BankController : Controller
    {
        //public IActionResult bank()
        //{
        //    return View();
        //}

        private readonly ApplicationDbContext _context;

        public BankController(ApplicationDbContext context)
        {
            _context = context;
        }

        public IActionResult bank()
        {
            //var comptes = _context.Comptes.Include(c => c.IdUtilisateurNavigation);
            //return View(await comptes.ToListAsync());
            var idUtilisateur = HttpContext.Session.GetInt32("IdUtilisateur");

            if (idUtilisateur == null)
            {
                return RedirectToAction("Acceuil", "Acceuil"); // Rediriger si l'utilisateur n'est pas en session
            }

            var comptes = _context.Comptes
                .Include(c => c.IdUtilisateurNavigation)
                .Where(c => c.IdUtilisateur == idUtilisateur.Value)
                .ToList();
            return View(comptes);
        }

        public async Task<IActionResult> Details(int? id)
        {
            if (id == null)
                return NotFound();

            var compte = await _context.Comptes
                .Include(c => c.IdUtilisateurNavigation)
                .FirstOrDefaultAsync(m => m.IdCompte == id);

            if (compte == null)
                return NotFound();

            return View(compte);
        }

        public IActionResult Create()
        {
            var idUtilisateur = HttpContext.Session.GetInt32("IdUtilisateur");
            if ( idUtilisateur!= 0)
            {
                var utilisateur = _context.Utilisateurs
                                          .Where(u => u.IdUtilisateur == idUtilisateur)
                                          .ToList();

                ViewData["IdUtilisateur"] = new SelectList(utilisateur, "IdUtilisateur", "Nom");
            }
            else
            {
                TempData["ErreurUtilisateur"] = "Utilisateur non connecté ou ID non trouvé.";
                ViewData["IdUtilisateur"] = new SelectList(new List<Utilisateur>(), "IdUtilisateur", "Nom");
            }

            //ViewData["IdUtilisateur"] = new SelectList(_context.Utilisateurs, "IdUtilisateur", "Nom");
            return View();
        }


        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Create([Bind("IdUtilisateur,Type,Solde")] Compte compte)
        {
            if (ModelState.IsValid)
            {
                try
                {
                    _context.Add(compte);
                    await _context.SaveChangesAsync();
                    return RedirectToAction("Bank", "bank");
                }
                catch (DbUpdateException ex)
                {
                    // Vérifier si l'erreur vient du trigger SQL
                    if (ex.InnerException is SqlException sqlEx) // Code d'erreur du THROW SQL Server
                    {
                        ModelState.AddModelError("", sqlEx.Message);
                    }
                    else
                    {
                        ModelState.AddModelError("", "Une erreur s'est produite lors de l'ajout du compte.");
                    }
                }
            }
            ViewData["IdUtilisateur"] = new SelectList(_context.Utilisateurs, "IdUtilisateur", "Nom", compte.IdUtilisateur);
            return View(compte);
        }


        public async Task<IActionResult> Edit(int? id)
        {
            if (id == null)
                return NotFound();

            var compte = await _context.Comptes.FindAsync(id);
            if (compte == null)
                return NotFound();

            var idUtilisateur = HttpContext.Session.GetInt32("IdUtilisateur");
            if (idUtilisateur != 0)
            {
                var utilisateur = _context.Utilisateurs
                                          .Where(u => u.IdUtilisateur == idUtilisateur)
                                          .ToList();

                ViewData["IdUtilisateur"] = new SelectList(utilisateur, "IdUtilisateur", "Nom");
            }
            else
            {
                TempData["ErreurUtilisateur"] = "Utilisateur non connecté ou ID non trouvé.";
                ViewData["IdUtilisateur"] = new SelectList(new List<Utilisateur>(), "IdUtilisateur", "Nom");
            }
            //ViewData["IdUtilisateur"] = new SelectList(_context.Utilisateurs, "IdUtilisateur", "Nom", compte.IdUtilisateur);
            return View(compte);
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Edit(int id, [Bind("IdCompte,IdUtilisateur,Type,Solde")] Compte compte)
        {
            if (id != compte.IdCompte)
                return NotFound();

            if (ModelState.IsValid)
            {
                try
                {
                    _context.Update(compte);
                    await _context.SaveChangesAsync();
                }
                catch (DbUpdateConcurrencyException)
                {
                    if (!_context.Comptes.Any(e => e.IdCompte == compte.IdCompte))
                        ModelState.AddModelError("", "Une erreur s'est produite lors de la modification du livre.");
                    else
                        throw;
                }
                return RedirectToAction("Bank", "bank");
                //return RedirectToAction(nameof(Index));
            }
            ViewData["IdUtilisateur"] = new SelectList(_context.Utilisateurs, "IdUtilisateur", "Nom", compte.IdUtilisateur);
            return View(compte);
        }

        public async Task<IActionResult> Delete(int? id)
        {
            if (id == null)
                return NotFound();

            var compte = await _context.Comptes
                .Include(c => c.IdUtilisateurNavigation)
                .FirstOrDefaultAsync(m => m.IdCompte == id);

            if (compte == null)
                return NotFound();

            return View(compte);
        }

        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> DeleteConfirmed(int id)
        {
            var compte = _context.Comptes
                .Include(c => c.Factures)
                .Include(c => c.Depenses)
                .Include(c => c.Revenus).FirstOrDefault(c => c.IdCompte == id);

            if (compte == null)
            {
                return NotFound();
            }

            try
            {
                _context.Depenses.RemoveRange(compte.Depenses);
                _context.Revenus.RemoveRange(compte.Revenus);
                _context.Factures.RemoveRange(compte.Factures);
                _context.Comptes.Remove(compte);
                //var compte = await _context.Comptes.FindAsync(id);
                //_context.Comptes.Remove(compte);
                await _context.SaveChangesAsync();
                return RedirectToAction("Bank", "bank");
            }
            catch (DbUpdateException ex)
            {
                // Vérifier si l'erreur vient du trigger SQL
                if (ex.InnerException is SqlException sqlEx) // Code d'erreur du THROW SQL Server
                {
                    ModelState.AddModelError("", sqlEx.Message);
                }
                else
                {
                    ModelState.AddModelError("", "Une erreur s'est produite lors de la suppression du compte.");
                    return View(compte);
                }
            }
            return View(compte);
            // Supprimer toutes les dépenses associées avant de supprimer le budget

        }
    }
}
