﻿using FamilyBudget.Models;
using Microsoft.AspNetCore.Identity.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.Text;
using FamilyBudget.ViewModels;

namespace FamilyBudget.Data
{
    public partial class ApplicationDbContext : DbContext
    {
        public ApplicationDbContext()
        {
        }

        public ApplicationDbContext(DbContextOptions<ApplicationDbContext> options)
            : base(options)
        {
        }

        public virtual DbSet<Bugdet> Bugdets { get; set; }
        public virtual DbSet<Compte> Comptes { get; set; }
        public virtual DbSet<Depense> Depenses { get; set; }
        public virtual DbSet<Facture> Factures { get; set; }
        public virtual DbSet<Revenu> Revenus { get; set; }
        public virtual DbSet<Utilisateur> Utilisateurs { get; set; }

        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        {
            if (!optionsBuilder.IsConfigured)
            {
//#warning To protect potentially sensitive information in your connection string, you should move it out of source code. You can avoid scaffolding the connection string by using the Name= syntax to read it from configuration - see https://go.microsoft.com/fwlink/?linkid=2131148. For more guidance on storing connection strings, see http://go.microsoft.com/fwlink/?LinkId=723263.
                optionsBuilder.UseSqlServer("Server=(localdb)\\MSSQLLocalDB;Database=Budget;Trusted_Connection=True;MultipleActiveResultSets=true");
            }
        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            modelBuilder.HasAnnotation("Relational:Collation", "SQL_Latin1_General_CP1_CI_AS");

            modelBuilder.Entity<Bugdet>(entity =>
            {
                entity.HasKey(e => e.IdBudget);

                entity.ToTable("bugdet");

                entity.Property(e => e.IdBudget).HasColumnName("id_budget");

                entity.Property(e => e.IdUtilisateur).HasColumnName("id_utilisateur");

                entity.Property(e => e.Categorie)
                    .IsRequired()
                    .HasMaxLength(128)
                    .IsUnicode(false)
                    .HasColumnName("categorie");

                entity.Property(e => e.MontantAlloue)
                    .HasColumnType("decimal(10, 2)")
                    .HasColumnName("montant_alloue");

                entity.HasOne(d => d.IdUtilisateurNavigation)
                    .WithMany(p => p.Bugdets)
                    .HasForeignKey(d => d.IdUtilisateur)
                    .OnDelete(DeleteBehavior.ClientSetNull)
                    .HasConstraintName("FK_bugdet_utilisateur");
            });

            modelBuilder.Entity<Compte>(entity =>
            {
                entity.HasKey(e => e.IdCompte);

                entity.ToTable("compte");

                entity.Property(e => e.IdCompte).HasColumnName("id_compte");

                entity.Property(e => e.IdUtilisateur).HasColumnName("id_utilisateur");

                entity.Property(e => e.Solde)
                    .HasColumnType("decimal(10, 2)")
                    .HasColumnName("solde");

                entity.Property(e => e.Type)
                    .IsRequired()
                    .HasMaxLength(128)
                    .IsUnicode(false)
                    .HasColumnName("type");

                entity.HasOne(d => d.IdUtilisateurNavigation)
                    .WithMany(p => p.Comptes)
                    .HasForeignKey(d => d.IdUtilisateur)
                    .OnDelete(DeleteBehavior.ClientSetNull)
                    .HasConstraintName("FK_compte_utilisateur");
            });

            modelBuilder.Entity<Depense>(entity =>
            {
                entity.HasKey(e => e.IdDepenses);

                entity.ToTable("depense");

                entity.Property(e => e.IdDepenses).HasColumnName("id_depenses");

                entity.Property(e => e.DateDepense)
                    .IsRequired()
                    .HasColumnType("date")
                    .HasColumnName("date_depense");

                entity.Property(e => e.IdBudget).HasColumnName("id_budget");

                //entity.Property(e => e.IdFacture).HasColumnName("id_facture");

                entity.Property(e => e.IdUtilisateur).HasColumnName("id_utilisateur");

                entity.Property(e => e.IdCompte).HasColumnName("id_compte");

                //entity.Property(e => e.Nom)
                //    .IsRequired()
                //    .HasMaxLength(128)
                //    .IsUnicode(false)
                //    .HasColumnName("nom");

                entity.Property(e => e.Montant)
                    .HasColumnType("decimal(10, 2)")
                    .HasColumnName("Montant");

                //entity.Property(e => e.Type)
                //    .IsRequired()
                //    .HasMaxLength(128)
                //    .IsUnicode(false)
                //    .HasColumnName("type");

                entity.HasOne(d => d.IdBudgetNavigation)
                    .WithMany(p => p.Depenses)
                    .HasForeignKey(d => d.IdBudget)
                    .OnDelete(DeleteBehavior.ClientSetNull)
                    .HasConstraintName("FK_depense_bugdet");

                //entity.HasOne(d => d.IdFactureNavigation)
                //    .WithMany(p => p.Depenses)
                //    .HasForeignKey(d => d.IdFacture)
                //    .OnDelete(DeleteBehavior.ClientSetNull)
                //    .HasConstraintName("FK_depense_facture");

                entity.HasOne(d => d.IdUtilisateurNavigation)
                    .WithMany(p => p.Depenses)
                    .HasForeignKey(d => d.IdUtilisateur)
                    .OnDelete(DeleteBehavior.ClientSetNull)
                    .HasConstraintName("FK_depense_utilisateur");

                entity.HasOne(d => d.Compte)
                .WithMany(c => c.Depenses)
                .HasForeignKey(d => d.IdCompte)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("FK_depense_compte");
            });

            modelBuilder.Entity<Facture>(entity =>
            {
                entity.HasKey(e => e.IdFacture);

                entity.ToTable("facture");

                entity.Property(e => e.IdFacture).HasColumnName("id_facture");

                entity.Property(e => e.IdCompte).HasColumnName("id_compte");

                entity.Property(e => e.CategorieFacture)
                    .IsRequired()
                    .HasMaxLength(32)
                    .IsUnicode(false)
                    .HasColumnName("categorie_facture")
                    .IsFixedLength(true);

                entity.Property(e => e.DateFacture)
                    .HasColumnType("date")
                    .HasColumnName("date_facture");

                entity.Property(e => e.Montant)
                    .HasColumnType("decimal(10, 2)")
                    .HasColumnName("montant");

                entity.HasOne(d => d.Compte)
                .WithMany(c => c.Factures)
                .HasForeignKey(d => d.IdCompte)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("FK_facture_compte");
            });

            modelBuilder.Entity<Revenu>(entity =>
            {
                entity.HasKey(e => e.IdRevenu);

                entity.ToTable("revenu");

                entity.Property(e => e.IdRevenu).HasColumnName("id_revenu");

                entity.Property(e => e.DateRevenu)
                    .HasColumnType("date")
                    .HasColumnName("date_revenu");

                entity.Property(e => e.IdCompte).HasColumnName("id_compte");

                entity.Property(e => e.SourceRevenu)
                    .IsRequired()
                    .HasMaxLength(32)
                    .IsUnicode(false)
                    .HasColumnName("source_revenu")
                    .IsFixedLength(true);

                entity.Property(e => e.Montant)
                    .HasColumnType("decimal(10, 2)")
                    .HasColumnName("montant");

                entity.HasOne(d => d.IdCompteNavigation)
                    .WithMany(p => p.Revenus)
                    .HasForeignKey(d => d.IdCompte)
                    .OnDelete(DeleteBehavior.ClientSetNull)
                    .HasConstraintName("FK_revenu_compte");
            });

            modelBuilder.Entity<Utilisateur>(entity =>
            {
                entity.HasKey(e => e.IdUtilisateur);

                entity.ToTable("utilisateur");

                entity.Property(e => e.IdUtilisateur).HasColumnName("id_utilisateur");

                entity.Property(e => e.Email)
                    .IsRequired()
                    .HasMaxLength(128)
                    .IsUnicode(false)
                    .HasColumnName("email");

                entity.Property(e => e.MotDePasse)
                    .HasMaxLength(32)
                    .IsUnicode(false)
                    .HasColumnName("mot_de_passe")
                    .IsFixedLength(true);

                entity.Property(e => e.Nom)
                    .IsRequired()
                    .HasMaxLength(128)
                    .IsUnicode(false)
                    .HasColumnName("nom");
            });

            OnModelCreatingPartial(modelBuilder);
        }

        partial void OnModelCreatingPartial(ModelBuilder modelBuilder);

        public DbSet<FamilyBudget.ViewModels.StatistiqueDepenseViewModel> StatistiqueDepenseViewModel { get; set; }
    }
}
