﻿using System;
using Microsoft.EntityFrameworkCore.Migrations;

namespace FamilyBudget.Data.Migrations
{
    public partial class mig2 : Migration
    {
        protected override void Up(MigrationBuilder migrationBuilder)
        {
            migrationBuilder.RenameColumn(
                name: "Montant",
                table: "revenu",
                newName: "montant");

            migrationBuilder.AlterColumn<decimal>(
                name: "montant",
                table: "revenu",
                type: "decimal(10,2)",
                nullable: false,
                oldClrType: typeof(decimal),
                oldType: "decimal(18,2)");

            migrationBuilder.AlterColumn<DateTime>(
                name: "date_depense",
                table: "depense",
                type: "date",
                nullable: false,
                defaultValue: new DateTime(1, 1, 1, 0, 0, 0, 0, DateTimeKind.Unspecified),
                oldClrType: typeof(DateTime),
                oldType: "date",
                oldNullable: true);

            migrationBuilder.AddColumn<int>(
                name: "IdCompte",
                table: "depense",
                type: "int",
                nullable: false,
                defaultValue: 0);

            migrationBuilder.AddColumn<decimal>(
                name: "Montant",
                table: "depense",
                type: "decimal(10,2)",
                nullable: false,
                defaultValue: 0m);

            migrationBuilder.CreateIndex(
                name: "IX_depense_IdCompte",
                table: "depense",
                column: "IdCompte");

            migrationBuilder.AddForeignKey(
                name: "FK_depense_compte",
                table: "depense",
                column: "IdCompte",
                principalTable: "compte",
                principalColumn: "id_compte",
                onDelete: ReferentialAction.Restrict);
        }

        protected override void Down(MigrationBuilder migrationBuilder)
        {
            migrationBuilder.DropForeignKey(
                name: "FK_depense_compte",
                table: "depense");

            migrationBuilder.DropIndex(
                name: "IX_depense_IdCompte",
                table: "depense");

            migrationBuilder.DropColumn(
                name: "IdCompte",
                table: "depense");

            migrationBuilder.DropColumn(
                name: "Montant",
                table: "depense");

            migrationBuilder.RenameColumn(
                name: "montant",
                table: "revenu",
                newName: "Montant");

            migrationBuilder.AlterColumn<decimal>(
                name: "Montant",
                table: "revenu",
                type: "decimal(18,2)",
                nullable: false,
                oldClrType: typeof(decimal),
                oldType: "decimal(10,2)");

            migrationBuilder.AlterColumn<DateTime>(
                name: "date_depense",
                table: "depense",
                type: "date",
                nullable: true,
                oldClrType: typeof(DateTime),
                oldType: "date");
        }
    }
}
