﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

#nullable disable

namespace FamilyBudget.Models
{
    public partial class Facture
    {
        public Facture()
        {
            //Depenses = new HashSet<Depense>();
        }

        [Key]
        public int IdFacture { get; set; }

        [Required(ErrorMessage = "Le compte est obligatoire.")]
        public int IdCompte { get; set; } // Clé étrangère vers Compte

        [Required(ErrorMessage = "La catégorie de la facture est obligatoire.")]
        [StringLength(100, ErrorMessage = "La catégorie de la facture ne peut pas dépasser 100 caractères.")]
        public string CategorieFacture { get; set; }

        [Required(ErrorMessage = "Le montant est obligatoire.")]
        [Column(TypeName = "decimal(18,2)")]
        [Range(0, double.MaxValue, ErrorMessage = "Le montant ne peut pas être négatif.")]
        public decimal Montant { get; set; }

        [Required(ErrorMessage = "La date de la facture est obligatoire.")]
        public DateTime DateFacture { get; set; } = DateTime.Now;

        // Relation avec Compte
        [ForeignKey("IdCompte")]
        public virtual Compte Compte { get; set; }
        //public virtual ICollection<Depense> Depenses { get; set; }
    }
}
