﻿using FamilyBudget.Data;
using FamilyBudget.Models;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Rendering;
using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace FamilyBudget.Controllers
{
    public class RevenuController : Controller
    {
        /*public IActionResult Index()
        {
            return View();
        }*/

        private readonly ApplicationDbContext _context;


        public RevenuController(ApplicationDbContext context)
        {
            _context = context;
        }

        public async Task<IActionResult> revenu()
        {
            var idUtilisateur = HttpContext.Session.GetInt32("IdUtilisateur");
            var revenus = _context.Revenus
                .Where(d => d.IdCompteNavigation.IdUtilisateur == idUtilisateur)
                .Include(r => r.IdCompteNavigation);

            return View(await revenus.ToListAsync());
        }



        public async Task<IActionResult> Details(int? id)
        {
            if (id == null)
                return NotFound();

            var revenu = await _context.Revenus
                .Include(r => r.IdCompteNavigation)
                .FirstOrDefaultAsync(m => m.IdRevenu == id);

            if (revenu == null)
                return NotFound();

            return View(revenu);
        }

        public IActionResult Create()
        {
            var idUtilisateur = HttpContext.Session.GetInt32("IdUtilisateur");

            if (idUtilisateur == null)
            {
                return RedirectToAction("Acceuil", "Acceuil"); // Rediriger si l'utilisateur n'est pas en session
            }
            ViewData["IdCompte"] = new SelectList(_context.Comptes
                                                        .Where(c => c.IdUtilisateur == idUtilisateur.Value)
                                                        , "IdCompte", "Type");
            return View();
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Create([Bind("IdCompte,SourceRevenu,Montant,DateRevenu")] Revenu revenu)
        {
            if (ModelState.IsValid)
            {
                _context.Add(revenu);
                // Mise à jour du solde du compte
                var compte = await _context.Comptes.FindAsync(revenu.IdCompte);
                if (compte != null)
                {
                    compte.Solde += revenu.Montant;
                    _context.Update(compte);
                }
                await _context.SaveChangesAsync();
                return RedirectToAction("Revenu", "revenu");
            }
            ViewData["IdCompte"] = new SelectList(_context.Comptes, "IdCompte", "Type", revenu.IdCompte);
            return View(revenu);
        }

        public async Task<IActionResult> Edit(int? id)
        {
            if (id == null)
                return NotFound();

            var revenu = await _context.Revenus.FindAsync(id);
            if (revenu == null)
                return NotFound();

            ViewData["IdCompte"] = new SelectList(_context.Comptes, "IdCompte", "Type", revenu.IdCompte);
            return View(revenu);
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Edit(int id, [Bind("IdRevenu,IdCompte,SourceRevenu,Montant,DateRevenu")] Revenu revenu)
        {
            if (id != revenu.IdRevenu)
                return NotFound();

            if (ModelState.IsValid)
            {
                try
                {
                    _context.Update(revenu);
                    await _context.SaveChangesAsync();
                }
                catch (DbUpdateConcurrencyException)
                {
                    if (!_context.Revenus.Any(e => e.IdRevenu == revenu.IdRevenu))
                        return NotFound();
                    else
                        throw;
                }
                return RedirectToAction("Revenu", "revenu");
            }
            ViewData["IdCompte"] = new SelectList(_context.Comptes, "IdCompte", "Type", revenu.IdCompte);
            return View(revenu);
        }

        public async Task<IActionResult> Delete(int? id)
        {
            if (id == null)
                return NotFound();

            var revenu = await _context.Revenus
                .Include(r => r.IdCompteNavigation)
                .FirstOrDefaultAsync(m => m.IdRevenu == id);

            if (revenu == null)
                return NotFound();

            return View(revenu);
        }

        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> DeleteConfirmed(int id)
        {
            var revenu = await _context.Revenus.FindAsync(id);
            if (revenu != null)
            {
                var compte = await _context.Comptes.FindAsync(revenu.IdCompte);
                if (compte != null)
                {
                    compte.Solde -= revenu.Montant;
                    _context.Update(compte);
                }

                _context.Revenus.Remove(revenu);
                await _context.SaveChangesAsync();
            }
            return RedirectToAction("Revenu", "revenu");
        }
    }
}
