﻿using Microsoft.EntityFrameworkCore.Migrations;

namespace FamilyBudget.Data.Migrations
{
    public partial class mig3 : Migration
    {
        protected override void Up(MigrationBuilder migrationBuilder)
        {
            migrationBuilder.DropForeignKey(
                name: "FK_depense_facture",
                table: "depense");

            migrationBuilder.DropIndex(
                name: "IX_depense_id_facture",
                table: "depense");

            migrationBuilder.DropColumn(
                name: "id_facture",
                table: "depense");

            migrationBuilder.DropColumn(
                name: "nom",
                table: "depense");

            migrationBuilder.DropColumn(
                name: "type",
                table: "depense");

            migrationBuilder.RenameColumn(
                name: "IdCompte",
                table: "depense",
                newName: "id_compte");

            migrationBuilder.RenameIndex(
                name: "IX_depense_IdCompte",
                table: "depense",
                newName: "IX_depense_id_compte");

            migrationBuilder.AddColumn<int>(
                name: "FactureIdFacture",
                table: "depense",
                type: "int",
                nullable: true);

            migrationBuilder.CreateIndex(
                name: "IX_depense_FactureIdFacture",
                table: "depense",
                column: "FactureIdFacture");

            migrationBuilder.AddForeignKey(
                name: "FK_depense_facture_FactureIdFacture",
                table: "depense",
                column: "FactureIdFacture",
                principalTable: "facture",
                principalColumn: "id_facture",
                onDelete: ReferentialAction.Restrict);
        }

        protected override void Down(MigrationBuilder migrationBuilder)
        {
            migrationBuilder.DropForeignKey(
                name: "FK_depense_facture_FactureIdFacture",
                table: "depense");

            migrationBuilder.DropIndex(
                name: "IX_depense_FactureIdFacture",
                table: "depense");

            migrationBuilder.DropColumn(
                name: "FactureIdFacture",
                table: "depense");

            migrationBuilder.RenameColumn(
                name: "id_compte",
                table: "depense",
                newName: "IdCompte");

            migrationBuilder.RenameIndex(
                name: "IX_depense_id_compte",
                table: "depense",
                newName: "IX_depense_IdCompte");

            migrationBuilder.AddColumn<int>(
                name: "id_facture",
                table: "depense",
                type: "int",
                nullable: false,
                defaultValue: 0);

            migrationBuilder.AddColumn<string>(
                name: "nom",
                table: "depense",
                type: "varchar(128)",
                unicode: false,
                maxLength: 128,
                nullable: false,
                defaultValue: "");

            migrationBuilder.AddColumn<string>(
                name: "type",
                table: "depense",
                type: "varchar(128)",
                unicode: false,
                maxLength: 128,
                nullable: false,
                defaultValue: "");

            migrationBuilder.CreateIndex(
                name: "IX_depense_id_facture",
                table: "depense",
                column: "id_facture");

            migrationBuilder.AddForeignKey(
                name: "FK_depense_facture",
                table: "depense",
                column: "id_facture",
                principalTable: "facture",
                principalColumn: "id_facture",
                onDelete: ReferentialAction.Restrict);
        }
    }
}
