﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

#nullable disable

namespace FamilyBudget.Models
{
    public partial class Bugdet
    {
        public Bugdet()
        {
            Depenses = new HashSet<Depense>();
        }

        [Key]
        public int IdBudget { get; set; }

        [Required(ErrorMessage = "L'utilisateur est obligatoire.")]
        public int IdUtilisateur { get; set; }

        [Required(ErrorMessage = "La categorie est obligatoire.")]
        [StringLength(100, ErrorMessage = "La catégorie ne peut pas dépasser 100 caractères.")]
        public string Categorie { get; set; }

        [Required(ErrorMessage = "Un montant est obligatoire.")]
        [Column(TypeName = "decimal(18,2)")]
        [Range(500, 1000000000, ErrorMessage = "Le montant ne doit pas être inferieur a 500")]
        public decimal MontantAlloue { get; set; }

        [ForeignKey("IdUtilisateur")]
        public virtual Utilisateur IdUtilisateurNavigation { get; set; }
        public virtual ICollection<Depense> Depenses { get; set; }
    }
}