﻿using FamilyBudget.Data;
using FamilyBudget.Models;
using Microsoft.AspNetCore.Http;
using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace FamilyBudget.Services
{
    public class CompteService
    {
        private readonly IHttpContextAccessor _httpContextAccessor;
        private readonly ApplicationDbContext _context;

        public CompteService(IHttpContextAccessor httpContextAccessor, ApplicationDbContext context)
        {
            _httpContextAccessor = httpContextAccessor;
            _context = context;
        }

        public async Task<List<Compte>> GetComptesUtilisateurAsync()
        {
            // Obtenez l'utilisateur connecté
            var utilisateur = _httpContextAccessor.HttpContext?.User;

            // Vérifiez si l'utilisateur est authentifié
            if (utilisateur == null || !utilisateur.Identity.IsAuthenticated)
            {
                throw new UnauthorizedAccessException("Utilisateur non connecté.");
            }

            // Récupérez l'identifiant de l'utilisateur connecté
            var idUtilisateur = int.Parse(utilisateur.FindFirst("IdUtilisateur")?.Value
                                          ?? throw new InvalidOperationException("Identifiant utilisateur non trouvé."));

            // Queryez les comptes de cet utilisateur
            var comptes = await _context.Comptes
                                        .Where(c => c.IdUtilisateur == idUtilisateur)
                                        .ToListAsync();

            return comptes;
        }

        }
    }
